/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

public class WSWSDLRefs {
    private static final String SOAPADDRESS_PREFIX = "soapaddress://";
    private static final String WSDLREF_SEPARATOR = "##";
    private String wsdlURI = null;
    private String wsdlRef = null;
    private String desc = null;

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public String getWsdlRef() {
        return this.wsdlRef;
    }

    public static WSWSDLRefs fromString(String canonicalWSDLURI) {
        if (canonicalWSDLURI.startsWith(SOAPADDRESS_PREFIX) && canonicalWSDLURI.contains(WSDLREF_SEPARATOR)) {
            int i = canonicalWSDLURI.indexOf(WSDLREF_SEPARATOR);
            return new WSWSDLRefs(canonicalWSDLURI.substring(SOAPADDRESS_PREFIX.length(), i), canonicalWSDLURI.substring(i + WSDLREF_SEPARATOR.length()));
        }
        return new WSWSDLRefs(canonicalWSDLURI, null);
    }

    public WSWSDLRefs(String wsdlURI, String wsdlRef) {
        this.wsdlURI = wsdlURI;
        this.wsdlRef = wsdlRef;
    }

    public String toString() {
        if (this.wsdlRef == null) {
            return this.wsdlURI;
        }
        if (this.desc == null) {
            StringBuilder b = new StringBuilder();
            b.append(SOAPADDRESS_PREFIX).append(this.wsdlURI).append(WSDLREF_SEPARATOR).append(this.wsdlRef);
            this.desc = b.toString();
        }
        return this.desc;
    }

    public static void main(String[] args) {
        if (args != null) {
            for (String s : args) {
                WSWSDLRefs r = WSWSDLRefs.fromString(s);
                System.out.println("WSDLURI=" + r.getWsdlURI());
                System.out.println("WSDLRef=" + r.getWsdlRef());
                System.out.println("Canonical form=" + r.toString());
            }
        }
    }
}

